<?php

namespace App\Gates;

use App\Exceptions\UnauthorizedException;
use App\Models\User;

class UserGate
{
  public static function canAuth(User $user)
  {
    if ($user->blocked) {
      $message = 'Your account is blocked. Please contact support.';
      throw new UnauthorizedException($message);
    }
  }
}
