<?php

namespace App\Http\Controllers;

use App\Repos\CreditRepo;
use App\Services\ResponseService;
use Illuminate\Http\Request;
use Throwable;

class CreditController extends Controller
{
    public function read(Request $request) {
        try {
            $user = $request->user();
            $credit = CreditRepo::findByUserId($user->id);
            return ResponseService::ok($credit);
        } catch (Throwable $error) {
            return ResponseService::handleError($error);
        }
    }
}
