<?php

namespace App\Http\Controllers;

use App\Repos\SettingRepo;
use App\Services\ResponseService;
use App\Services\ValidationService;
use Illuminate\Http\Request;
use Throwable;

class SettingController extends Controller
{
    public function list() {
        try {
            $result = SettingRepo::list();
            return ResponseService::ok($result);
        } catch (Throwable $error) {
            return ResponseService::handleError($error);
        }
    }

    public function update(Request $request, string $name) {
        try {
            $rules = [
                'value' => ['required'],
            ];
            ValidationService::validate($request->all(), $rules);
            SettingRepo::updateValueByName($name, $request->value);
            $result = ['updated' => true];
            return ResponseService::ok($result);
        } catch (Throwable $error) {
            return ResponseService::handleError($error);
        }
    }
}
