<?php

namespace App\Http\Controllers;

use App\Services\ResponseService;
use App\Services\StorageService;
use App\Services\ValidationService;
use Illuminate\Http\Request;
use Throwable;

class StorageController extends Controller
{
    public function upload(Request $request)
    {
        try {
            $rules = [
                'file' => ['required', 'file'],
            ];
            ValidationService::validate($request->all(), $rules);
            $file = $request->file('file');
            $url = StorageService::upload($file);
            $result = ['url' => $url];
            return ResponseService::ok($result);
        } catch (Throwable $error) {
            return ResponseService::handleError($error);
        }
    }

    public function download(Request $request, $path)
    {
        try {
            $request->merge(compact('path'));
            $rules = [
                'path' => ['required', 'string'],
            ];
            ValidationService::validate($request->all(), $rules);
            return ResponseService::storage($path);
        } catch (Throwable $error) {
            return ResponseService::handleError($error);
        }
    }
}
