<?php

namespace App\Repos;

use App\Models\Setting;

class SettingRepo
{
    public static function list()
    {
        return Setting::whereIn('name', [
            'app_name',
            'tagline',
            'favicon',
            'website'
        ])->get();
    }

    public static function updateValueByName(string $name, mixed $value)
    {
        return Setting::whereName($name)->update(['value' => $value]);
    }

    public static function hasValueByName(string $name)
    {
        return Setting::whereName($name)
            ->whereNotNull('value')
            ->exists();
    }

    public static function findByNameOrFail(string $name)
    {
        return Setting::whereName($name)->firstOrFail();
    }
}
