<?php

namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Carbon;

trait DailyCountBetweenDate {
    public function scopeDailyCountBetweenDate(Builder $query, Carbon $start, Carbon $end) {
        return $query->selectRaw('DATE_FORMAT(created_at, "%b %e") as date, COUNT(*) as count')
            ->whereBetween('created_at', [$start, $end])
            ->groupBy('date');
    }
}