<?php

namespace App\Services;

use App\Exceptions\UnprocessableException;
use Illuminate\Support\Facades\Validator;

class ValidationService {
    public static function validate(array $data, array $rules) {
        $validator = Validator::make($data, $rules);
        if ($validator->stopOnFirstFailure()->fails()) {
            $message = $validator->errors()->first();
            throw new UnprocessableException($message);
        }
    }
}