<?php

namespace App\Utils;

use Illuminate\Support\Facades\File;

class FileUtil
{
    public static function mimeTypeFromPath(string $path)
    {
        $extension = File::extension($path);
        $mimeTypes = [
            'html' => 'text/html',
            'js' => 'application/javascript',
            'css' => 'text/css',
            'jpeg' => 'image/jpeg',
            'svg' => 'image/svg+xml',
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'webp' => 'image/webp',
            'mp4' => 'video/mp4',
            'ttf' => 'font/ttf',
            'eot' => 'application/vnd.ms-fontobject',
            'woff' => 'font/woff',
            'woff2' => 'font/woff2',
        ];
        return isset($mimeTypes[$extension])
            ? $mimeTypes[$extension]
            : File::mimeType($path);
    }
}
