<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->string('stripe_price_id')->uniqid()->nullable();
            $table->string('name')->uniqid();
            $table->string('title');
            $table->string('description');
            $table->decimal('price');
            $table->unsignedInteger('public_page_limit');
            $table->unsignedInteger('page_creation_limit');
            $table->boolean('paid');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
