<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('stripe_id')->nullable()->uniqid();
            $table->foreignId('plan_id')->nullable()->constrained();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('photo')->nullable();
            $table->uuid('auth_token')->nullable();
            $table->uuid('verify_token')->nullable();
            $table->integer('otp')->nullable();
            $table->boolean('blocked')->default(false);
            $table->boolean('admin')->default(false);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
