<?php

namespace Database\Seeders;

use App\Models\Page;
use App\Models\User;
use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::excludeAdmin()->get();
        $users->each(function ($user) {
            Page::factory()
                ->count(50)
                ->create(['user_id' => $user->id]);
        });
    }
}
