<?php

namespace Database\Seeders;

use App\Models\Plan;
use Illuminate\Database\Seeder;

class PlanSeeder extends Seeder
{
    public function run(): void
    {
        $plans = [
            [
                'name' => 'free',
                'title' => 'Free',
                'description' => 'A simple way to explore and get started.',
                'price' => 0,
                'public_page_limit' => 3,
                'page_creation_limit' => 2,
                'paid' => false,
            ],
            [
                'name' => 'starter',
                'title' => 'Starter',
                'description' => 'Enhanced access for creative coloring.',
                'price' => 9.99,
                'public_page_limit' => 30,
                'page_creation_limit' => 15,
                'paid' => true,
            ],
            [
                'name' => 'advanced',
                'title' => 'Advanced',
                'description' => 'Experience the full creative potential.',
                'price' => 14.99,
                'public_page_limit' => 60,
                'page_creation_limit' => 30,
                'paid' => true,
            ]
        ];
        Plan::insert($plans);
    }
}
