<?php

use App\Http\Controllers\AnalyticController;
use App\Http\Controllers\AppController;
use App\Http\Controllers\ColoredController;
use App\Http\Controllers\CreditController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\StorageController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\UserController;
use App\Http\Middleware\AuthMiddleware;
use App\Http\Middleware\CorsEnabled;
use Illuminate\Support\Facades\Route;

Route::controller(UserController::class)
    ->prefix('users')
    ->group(function () {
        Route::post('/sign-up', 'signUp');
        Route::post('/sign-in', 'signIn');
        Route::post('/verify', 'verify');
    });

Route::controller(SettingController::class)
    ->prefix('settings')
    ->group(function () {
        Route::get('/list', 'list');
    });

Route::get('/plans/list', [PlanController::class, 'list']);
Route::post('/stripe/webhook', [StripeController::class, 'webhook']);
Route::post('/users/admin/create', [UserController::class, 'createAdmin']);
Route::get('/app/status', [AppController::class, 'status']);

Route::get('/storage/{path}', [StorageController::class, 'download'])
    ->where('path', '.*')
    ->middleware(CorsEnabled::class)
    ->name('storage');

Route::middleware(AuthMiddleware::class)
    ->group(function () {
        Route::controller(UserController::class)
            ->prefix('users')
            ->group(function () {
                Route::get('/read', 'read');
                Route::patch('/update', 'update');
                Route::get('/paginate', 'paginate');
                Route::patch('/{id}/blocked/toggle', 'toggleBlocked');
            });

        Route::controller(PageController::class)
            ->prefix('pages')
            ->group(function () {
                Route::get('/{id}/read', 'read');
                Route::get('/paginate', 'paginate');
                Route::patch('/{id}/blocked/toggle', 'toggleBlocked');
                Route::patch('/{id}/favorited/toggle', 'toggleFavorited');
                Route::get('/prompt/generate', 'generatePrompt');
                Route::post('/create', 'create');
            });

        Route::controller(PlanController::class)
            ->prefix('plans')
            ->group(function () {
                Route::get('/paid/list', 'listPaid');
                Route::get('/{id}/read', 'read');
                Route::post('/{id}/update', 'update');
            });

        Route::controller(ColoredController::class)
            ->prefix('coloreds')
            ->group(function () {
                Route::patch('/upsert', 'upsert');
                Route::get('/paginate', 'paginate');
            });

        Route::controller(AnalyticController::class)
            ->prefix('analytics')
            ->group(function () {
                Route::get('/counters', 'counters');
                Route::get('/charts', 'charts');
            });

        Route::post('/storage/upload', [StorageController::class, 'upload']);
        Route::patch('/settings/{name}/update', [SettingController::class, 'update']);
        Route::get('/subscriptions/paginate', [SubscriptionController::class, 'paginate']);
        Route::get('/credits/read', [CreditController::class, 'read']);
        Route::post('/stripe/checkout', [StripeController::class, 'checkout']);
        Route::post('/stripe/subscription/cancel', [StripeController::class, 'cancelSubscription']);
    });
